import { View, Text, TouchableOpacity } from "react-native";
import React from "react";
import { getMonthName } from "../../../helper/getMonthName";
import { orderHistoryStyle } from "../OrderHistory/OrderHistoryStyle";
import CustomRating from "../../Utilities/CustomRating/CustomRating";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { myReviresStyle } from "./MyReviewsStyle";
import DotIcon from "../../../assets/svgs/order history/dot.svg";
import DownIcon from "../../../assets/svgs/dropdown/down.svg";
import UpIcon from "../../../assets/svgs/dropdown/up.svg";
import EditIcon from "../../../assets/svgs/profile/edit profile.svg";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import { useNavigation } from "@react-navigation/native";
import { round } from "../../../helper/ratingRound";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const dotSize = dpr(6);
const SingleReview = ({
    item,
    showDetails,
    setShowDetails,
    dropdownRef1,
    dropdownRef2,
}) => {
    const { trans } = useLangTranslation();
    const navigation = useNavigation();
    let month, year, day;
    const dateArray = item?.created_at?.split("-");
    if (dateArray?.length > 0) {
        day = dateArray[0];
        month = getMonthName(dateArray[1]);
        year = dateArray[2];
    }

    const handleShowDetails = (id) => {
        setShowDetails({
            id: id,
            show: false,
        });
    };
    const handleHideDetails = (id) => {
        setShowDetails({
            id: id,
            show: true,
        });
    };

    return (
        <View style={orderHistoryStyle.item}>
            <View style={orderHistoryStyle.header}>
                <Text style={orderHistoryStyle.headerText} numberOfLines={2}>
                    {item?.product_name}
                </Text>

                <CustomRating
                    rating={round(item?.rating)}
                    starSize={dpr(18)}
                    readOnly={true}
                />
            </View>
            <View style={myReviresStyle.detailsCont}>
                <View style={orderHistoryStyle.info}>
                    <View style={orderHistoryStyle.infoTextCont}>
                        <CustomSVG svgIcon={DotIcon}
                            height={dotSize}
                            width={dotSize}
                            fill={"#C4C4C4"}
                        />
                        <Text style={orderHistoryStyle.infoText}>
                            {`${day} ${month}, ${year}`}
                        </Text>
                    </View>
                    <View style={orderHistoryStyle.infoTextCont}>
                        <CustomSVG svgIcon={DotIcon}
                            height={dotSize}
                            width={dotSize}
                            fill={"#C4C4C4"}
                        />
                        <Text style={orderHistoryStyle.infoText}>
                            {item.rating} {trans("Stars")}
                        </Text>
                    </View>
                    <View style={orderHistoryStyle.infoTextCont}>
                        <CustomSVG svgIcon={DotIcon}
                            height={dotSize}
                            width={dotSize}
                            fill={"#C4C4C4"}
                        />
                        <Text style={orderHistoryStyle.infoText}>
                            {item.status}
                        </Text>
                    </View>
                </View>
                <View>
                    {showDetails.id === item.id && showDetails.show ? (
                        <TouchableOpacity
                            onPress={() => handleShowDetails(item.id)}
                            style={myReviresStyle.dropDown}
                        >
                            <CustomSVG svgIcon={UpIcon} />
                        </TouchableOpacity>
                    ) : (
                        <TouchableOpacity
                            onPress={() => handleHideDetails(item.id)}
                            style={myReviresStyle.dropDown}
                        >
                            <CustomSVG svgIcon={DownIcon} fill={"#2C2C2C"} />
                        </TouchableOpacity>
                    )}
                </View>
            </View>
            <View>
                {showDetails.id === item.id && showDetails.show && (
                    <View>
                        <Text style={myReviresStyle.detailsTitle}>
                            {trans("Review you wrote")}
                        </Text>
                        <Text style={myReviresStyle.detailsText}>
                            {item.comments}
                        </Text>
                        <View style={myReviresStyle.detailsImgCont}>
                            <View style={myReviresStyle.detailsImg}>
                                {item?.image?.slice(0, 4).map((img, index) => (
                                    <ProgressiveImage
                                        key={index}
                                        source={{ uri: img }}
                                        style={myReviresStyle.detailsSingleImg}
                                    />
                                ))}
                                {item?.image.length > 4 && (
                                    <TouchableOpacity
                                        style={myReviresStyle.layerImg}
                                        onPress={() =>
                                            navigation.navigate("Edit Review", {
                                                dropdownRef1: dropdownRef1,
                                                dropdownRef2: dropdownRef2,
                                                setDate: setDate,
                                                setStatus: setStatus,
                                                item: item,
                                            })
                                        }
                                    >
                                        <View>
                                            <Text
                                                style={
                                                    myReviresStyle.layerImgText
                                                }
                                            >
                                                +{item?.image.length - 4}
                                            </Text>
                                        </View>
                                    </TouchableOpacity>
                                )}
                            </View>
                            <TouchableOpacity
                                onPress={() =>
                                    navigation.navigate("Edit Review", {
                                        dropdownRef1: dropdownRef1,
                                        dropdownRef2: dropdownRef2,
                                        setDate: setDate,
                                        setStatus: setStatus,
                                        item: item,
                                    })
                                }
                            >
                                <View style={myReviresStyle.editReviewCont}>
                                    <CustomSVG svgIcon={EditIcon}
                                        height={dpr(12)}
                                        width={dpr(12)}
                                    />
                                    <Text style={myReviresStyle.editText}>
                                        {trans("Edit Review")}
                                    </Text>
                                </View>
                            </TouchableOpacity>
                        </View>
                    </View>
                )}
            </View>
        </View>
    );
};

export default SingleReview;
